/*
 * Decompiled with CFR 0.152.
 */
package de.miraisoft.loginmessages;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import de.miraisoft.loginmessages.LMArgumentFirst;
import de.miraisoft.loginmessages.LMArgumentSecond;
import de.miraisoft.loginmessages.LMCommand;
import de.miraisoft.loginmessages.LMFormatter;
import de.miraisoft.loginmessages.MessageUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.commands.Commands;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="miraisoftloginmessages")
@Mod.EventBusSubscriber(modid="miraisoftloginmessages", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class LoginMessagesMod {
    public static final String MOD_ID = "miraisoftloginmessages";
    private static final Logger logger = LogManager.getLogger();
    private static final Path directory = Paths.get("config/miraisoftloginmessages", new String[0]);
    private static final File file = new File(directory.toUri().getPath() + "/loginmessages.conf");
    private static final int MOD_PERMISSION_LEVEL = 3;

    public LoginMessagesMod() {
        if (!directory.toFile().exists()) {
            try {
                Files.createDirectory(directory, new FileAttribute[0]);
            }
            catch (IOException e) {
                logger.error("[init] Could not create config directory", (Throwable)e);
            }
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
        logger.debug("[init] Mod miraisoftloginmessages is initialized");
        try {
            DeferredRegister argTypeRegistry = DeferredRegister.create((ResourceKey)Registry.f_235724_, (String)MOD_ID);
            argTypeRegistry.register("lmargument0", () -> (LMArgumentFirst.Info)ArgumentTypeInfos.registerByClass(LMArgumentFirst.class, (ArgumentTypeInfo)new LMArgumentFirst.Info()));
            argTypeRegistry.register("lmargument1", () -> (LMArgumentSecond.Info)ArgumentTypeInfos.registerByClass(LMArgumentSecond.class, (ArgumentTypeInfo)new LMArgumentSecond.Info()));
            argTypeRegistry.register(FMLJavaModLoadingContext.get().getModEventBus());
        }
        catch (Exception e) {
            logger.error("[init] Cannot register argument types", (Throwable)e);
        }
    }

    public static File getFile() {
        return file;
    }

    @SubscribeEvent
    public void registerCommand(RegisterCommandsEvent event) {
        try {
            CommandDispatcher dispatcher = event.getDispatcher();
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"loginmessage").requires(source -> source.m_6761_(3))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"arg0", (ArgumentType)new LMArgumentFirst()).requires(source -> source.m_6761_(3))).executes((Command)new LMCommand())).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"arg1", (ArgumentType)new LMArgumentSecond()).requires(source -> source.m_6761_(3))).executes((Command)new LMCommand()))));
            logger.debug("[registerCommand] Command /loginmessage has successfully been registered");
        }
        catch (Exception e) {
            logger.error("[registerCommand] Failed to register command /loginmessage", (Throwable)e);
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (file.exists()) {
            try {
                BufferedReader reader = new BufferedReader(new FileReader(file));
                int n = 0;
                while (reader.ready()) {
                    StringBuffer lineBuffer = new StringBuffer();
                    lineBuffer.append(LMFormatter.getDefaultLineFormatting(n));
                    lineBuffer.append(LMFormatter.convertBeforeDisplaying(reader.readLine(), player));
                    MessageUtil.send(player, lineBuffer.toString());
                    ++n;
                }
                reader.close();
            }
            catch (Exception e) {
                logger.error("[onPlayerLogin] Could not display login messages", (Throwable)e);
            }
        }
    }
}

